//
// This file contains a 'Sample Driver' and is licensed as such
// under the terms of your license agreement with Intel or your
// vendor.  This file may be modified by the user, subject to
// the additional terms of the license agreement
//
/** @file
  GUID is for UserPassword variable.

  Copyright (c) 2017, Intel Corporation. All rights reserved.<BR>
  This software and associated documentation (if any) is furnished
  under a license and may only be used or copied in accordance
  with the terms of the license. Except as permitted by such
  license, no part of this software or documentation may be
  reproduced, stored in a retrieval system, or transmitted in any
  form or by any means without the express written consent of
  Intel Corporation.

**/

#ifndef __USER_AUTHENTICATION_GUID_H__
#define __USER_AUTHENTICATION_GUID_H__

#define PASSWORD_MIN_SIZE    9  // MIN number of char of password, including NULL
#define PASSWORD_MAX_SIZE    32 // MAX number of char of password, including NULL
#define PASSWORD_SALT_SIZE   32
#define PASSWORD_HASH_SIZE   32 // SHA256_DIGEST_SIZE

#define PASSWORD_MAX_TRY_COUNT  3
#define PASSWORD_HISTORY_CHECK_COUNT  5

//
// Vendor GUID of the variable
//
#define ADMIN_AUTHENTICATION_GUID \
  { 0xee24a7f7, 0x606b, 0x4724, { 0xb3, 0xc9, 0xf5, 0xae, 0x4a, 0x3b, 0x81, 0x65} }

//
// Name of the variable
//
#define USER_AUTHENTICATION_VAR_NAME L"Password"
#define USER_AUTHENTICATION_HISTORY_LAST_VAR_NAME L"PasswordLast"

//
// Variable storage
//
typedef struct {
  UINT8        PasswordHash[PASSWORD_HASH_SIZE];
  UINT8        PasswordSalt[PASSWORD_SALT_SIZE];
} USER_PASSWORD_VAR_STRUCT;

typedef struct {
  UINTN       Function;
  EFI_STATUS  ReturnStatus;
  EFI_GUID    UserGuid;
} SMM_PASSWORD_COMMUNICATE_HEADER;

#define SMM_PASSWORD_FUNCTION_IS_PASSWORD_SET     1
#define SMM_PASSWORD_FUNCTION_SET_PASSWORD        2
#define SMM_PASSWORD_FUNCTION_VERIFY_PASSWORD     3

typedef struct {
  CHAR8                                 NewPassword[PASSWORD_MAX_SIZE];
  CHAR8                                 OldPassword[PASSWORD_MAX_SIZE];
} SMM_PASSWORD_COMMUNICATE_SET_PASSWORD;

typedef struct {
  CHAR8                                 Password[PASSWORD_MAX_SIZE];
} SMM_PASSWORD_COMMUNICATE_VERIFY_PASSWORD;

#endif
